* Title: 	table5.do
* Version: 	23 May 2018
* Purpose: 	Recreate Nakamura/Steinsson using data on prime-age males
 
*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table5, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Construct state-level employment variables from ASEC 
*******************************************************************************

use year statefip PrimeMaleD UnempB wtsupp ///
		using dta/asec_clean, clear
		
* Keep only prime-age men
keep if PrimeMaleD == 1
		
collapse (sum)  Total = PrimeMaleD  ///
				Jobless = UnempB /// 
				[pw=wtsupp], by(year statefip)
				
gen double Jobless_Rate = Jobless / Total


*******************************************************************************
* (2) Merge with Nakamura/Steinsson data
*******************************************************************************
keep if year>=1977 & year<=2006
merge m:1 statefip using dta/convert_statefip, assert(matched) nogen
rename StateAbv state
merge 1:1 year state using dta/statefiscal.dta, assert(matched using) keep(matched) nogen
sort year


*******************************************************************************
* (3) Generate regression variables
*******************************************************************************
xtset statenum year
sort statenum year

* Create one-, two-, and three-year percentage change in joblessness and spending variables
forval i = 1/3 {
	gen double Jobless_`i'y_Percent = (Jobless_Rate - L`i'.Jobless_Rate) / L`i'.Jobless_Rate

	gen double Drcapspend_`i'y 	= (rcapspend - L`i'.rcapspend)/L`i'.rcapout
	gen double Drcapspend_nat_`i'y = (rcapspend_nat - L`i'.rcapspend_nat)/L`i'.rcapout_nat
}

keep if year>=1980 & year<=2006

* Create dummy for high jobless state (75th percentile of mean jobless rate or higher)
* Note: We subtract a tiny amount from the 75th percentile to ensure 
*       the classification of Montana is consistently High_Unemp = 1

preserve
collapse (mean) Jobless_Rate, by(statefip)
summ Jobless_Rate, detail
gen High_Unemp = (Jobless_Rate >= `r(p75)'-0.0001)
tempfile high_unemp
save `high_unemp'

restore
merge m:1 statefip using `high_unemp', assert(matched) nogen

forval i = 1/3 {

	qui: xi: areg Drcapspend_`i'y i.statenum*Drcapspend_nat_`i'y, absorb(year)
	predict dem_Drcapspend_pred_`i'y, xbd

	gen Drcapspendhi_`i'y 	= Drcapspend_`i'y			* High_Unemp
	gen insthi_`i'y			= dem_Drcapspend_pred_`i'y	* High_Unemp

}

* Save dataset
keep year statenum statefip Jobless* Drcapspend*y insthi*y dem_Drcapspend*
save output/tables/dta/table5.dta, replace


*******************************************************************************
* (4) Regressions
*******************************************************************************

* Column 1: 1-year change, all states (N&S Table 2)
xi: ivreg2 Jobless_1y_Percent 	(Drcapspend_1y = i.statenum*Drcapspend_nat_1y) ///
								i.year i.statenum, partial(i.year i.statenum) cluster(statefip)

* Column 2: 1-year change, high- vs. low-joblessness states (N&S Table 5)
xi: ivreg2 Jobless_1y_Percent 	(Drcapspend_1y Drcapspendhi_1y  = dem_Drcapspend_pred_1y insthi_1y) ///
								i.year i.statenum, partial(i.year i.statenum) cluster(statefip)

* Column 3: 2-year change, all states (N&S Table 2)
xi: ivreg2 Jobless_2y_Percent 	(Drcapspend_2y = i.statenum*Drcapspend_nat_2y) ///
								i.year i.statenum, partial(i.year i.statenum) cluster(statefip)

* Column 4: 2-year change, high- vs. low-joblessness states (N&S Table 5)
xi: ivreg2 Jobless_2y_Percent 	(Drcapspend_2y Drcapspendhi_2y  = dem_Drcapspend_pred_2y insthi_2y) ///
								i.year i.statenum, partial(i.year i.statenum) cluster(statefip)

* Column 5: 3-year change, all states (N&S Table 2)
xi: ivreg2 Jobless_3y_Percent 	(Drcapspend_3y = i.statenum*Drcapspend_nat_3y) ///
								i.year i.statenum, partial(i.year i.statenum) cluster(statefip)

* Column 6: 3-year change, high- vs. low-joblessness states (N&S Table 5)
xi: ivreg2 Jobless_3y_Percent 	(Drcapspend_3y Drcapspendhi_3y  = dem_Drcapspend_pred_3y insthi_3y) ///
								i.year i.statenum, partial(i.year i.statenum) cluster(statefip)


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
